﻿using UnityEngine;
using System.Collections;

#pragma warning disable 414
public class SetWireframe : MonoBehaviour {
	public bool useWireframe = false;
	
	private bool wireframeMode;
	private bool showFPS = false;

	void Awake() {
		wireframeMode = useWireframe;
		showFPS = PlayerPrefs.GetInt("FPS", 0)==1;
	}

#if UNITY_STANDALONE_OSX || UNITY_STANDALONE_WIN || UNITY_EDITOR
	// Update is called once per frame
	void Update () {
		if (Input.GetKeyDown ("w")) {
			wireframeMode = !wireframeMode;
		}
	}
	
	void OnPreRender() {
		GL.wireframe = wireframeMode;
	}
	
	void OnPostRender() {
		GL.wireframe = false;
	}
#endif
}
